Scriptname RF:FuelHandlerQuest Extends Quest

Group Quests
    RF:TravelHandlerQuest Property TravelManager Mandatory Const Auto
    RF:TutorialQuest Property TutorialManager Mandatory Const Auto
    RF:DisasterScript Property DisasterManager Mandatory Const Auto
    SQ_PlayerShipScript Property SQ_PlayerShip Auto
    DialogueShipServicesScript Property DialogueShipServices Auto Const mandatory
EndGroup

Group AVs
    ActorValue Property SpaceshipGravJumpFuel auto const mandatory
    ActorValue Property SpaceshipPartsMass Mandatory Const Auto
    ActorValue Property SpaceshipGravJumpCalculation Mandatory Const Auto
EndGroup

Group System
    Perk Property _RF_Perk Mandatory Const Auto
    { This will hold our SPEL ability to control grav jump range }
    GlobalVariable Property _RF_Sys_ModEnabled Mandatory Const Auto
    GlobalVariable Property _RF_Sys_AllowTravel Mandatory Const Auto
    GlobalVariable Property _RF_Sys_Hardcore Mandatory Const Auto
    GlobalVariable Property _RF_Sys_Verbose Mandatory Const Auto
    ;DEBUG
    Potion Property DebugPotion1 Mandatory Const Auto
    Potion Property DebugPotion2 Mandatory Const Auto
    Potion Property DebugPotion3 Mandatory Const Auto
    Potion Property DebugPotion4 Mandatory Const Auto
    GlobalVariable Property _RF_DTV Mandatory Const Auto
    { This lets us force certain random events }
    ;States
    GlobalVariable Property _RF_State_CanActivateCargoPanel Mandatory Const Auto
    { This smartly determines which action to take }
EndGroup

Group Travel

    Location[] Property StarSystemsCore Mandatory Const Auto
    { 0:SOL 1:AC 2:CHEYENNE 3:VOLII }
    Location[] Property StarSystemsPeriphery Mandatory Const Auto
    { Fuel is drained here according to whether it's to/from here }
    Location[] Property StarSystemsOuterRim Mandatory Const Auto
    { Fuel is drained moderately when traveling to/from here }
    Keyword Property LocTypeMajorOrbital Mandatory Const Auto
    Keyword Property LocTypeOutpost Mandatory Const Auto
    Keyword Property LocTypeStarSystem Mandatory Const Auto
    Keyword Property LocTypeStarstationExterior Mandatory Const Auto
    Location[] Property UCStarstations Mandatory Const Auto
    { This can trip us up if we are in combat near one, but... I don't think that's likely. }
    Faction Property CrimeFactionCrimsonFleet Mandatory Const Auto
	Faction Property CrimeFactionFreestar Mandatory Const Auto
	Faction Property CrimeFactionParadiso Mandatory Const Auto
	Faction Property CrimeFactionRedMile Mandatory Const Auto
	Faction Property CrimeFactionUC Mandatory Const Auto
    Formlist Property _RF_TwinStarFormlist Mandatory Const Auto
    Keyword Property LocTypeSettledPlanet Mandatory Const Auto
EndGroup

Group Ship
    Keyword Property LocTypeSettlement Mandatory Const Auto
    Keyword Property ShipManufacturerDeimos Mandatory Const Auto
    Keyword Property ShipManufacturerHopeTech Mandatory Const Auto
    Keyword Property ShipManufacturerNova Mandatory Const Auto
    Keyword Property ShipManufacturerStroud Mandatory Const Auto
    Keyword Property ShipManufacturerTaiyo Mandatory Const Auto
    Keyword[] Property ShipModuleClasses Mandatory Const Auto
    { 0-3 A-M }
    GlobalVariable[] Property ShipModuleClassMults Mandatory Const Auto
    { 0:40 1:70 2:120 3:220}
    ConditionForm[] Property AstrodynamicsRank Mandatory Const Auto
    { 0:none etc }
    GlobalVariable[] Property AstrodynamicsMults Mandatory Const Auto
    { These can match vanilla for now }
    LocationRefType Property Ship_PilotSeat_RefType Mandatory Const Auto
    { To check if we sat in pilot's seat }
    ConditionForm Property _RF_COND_PlayerShipInterior Mandatory Const Auto
    { I could use ENV_CND_InSealedShip but I want to be sure it's our ship... for now I guess }
    GlobalVariable Property _RF_Val_SiphoningCrimeGoldValue Mandatory Const Auto
    Potion Property _RF_FuelSiphon Mandatory Const Auto
    { I would like to restrict functionality to this item somehow. Maybe greater efficiency? }
    Potion[] Property FuelTanks Mandatory Const Auto
    { In ascending order of quality }
    MiscObject property InorgCommonHelium3 auto const mandatory
    { Only for emergencies! }
    Quest Property MQ101 Mandatory Const Auto
    GlobalVariable Property _RF_State_IsRefuelingOK Mandatory Const Auto
    { This is only set to 1 while using smartfuel now }
    GlobalVariable Property _RF_Drain Mandatory Const Auto
    { should be around 12 with current calcs }
EndGroup

Group Messages
    Message Property _RF_Message_FuelRemainingOK Mandatory Const Auto
    { Above 50% at breakpoints }
    Message Property _RF_Message_FuelRemainingLOW Mandatory Const Auto
    { Below 50% above 25% }
    Message Property _RF_Message_FuelRemainingNG Mandatory Const Auto
    { Below 25% }
    Message Property _RF_SiphonFuelWarning Mandatory Const Auto
    Message Property _rf_item_failure Mandatory Const Auto
    Message Property _rf_purchase_complementary Mandatory Const Auto
    Message Property _rf_smartfuel_busy Mandatory Const Auto
    Message Property _rf_smartfuel_failure Mandatory Const Auto
    Message Property _rf_smartfuel_foundhelium Mandatory Const Auto
    Message Property _rf_smartfuel_foundtank Mandatory Const Auto
    Message Property _rf_smartfuel_init Mandatory Const Auto
    Message Property _rf_siphon_begin_generic Mandatory Const Auto
    Message Property _rf_siphon_begin_item Mandatory Const Auto
    Message Property _rf_siphon_begin_oldship Mandatory Const Auto
    Message Property _rf_siphon_fail_cancel Mandatory Const Auto
    Message Property _rf_siphon_fail_generic Mandatory Const Auto
    Message Property _rf_siphon_fail_oldship Mandatory Const Auto
    Message Property _rf_siphon_success Mandatory Const Auto
    Message Property _rf_takeover Mandatory Const Auto
    Message Property _RF_Fueling_Message_starting Mandatory Const Auto
    Message Property _RF_Fueling_Message_OK Mandatory Const Auto
    ;FX
    Spell Property _RF_FX_He3soundeffect Mandatory Const Auto
    WwiseEvent Property SoundWhenTriggeringSmartFuel Mandatory Const Auto
    { Something short and clicky, no big ship noises yet }
    WwiseEvent Property SoundForRawFuelRefill Mandatory Const Auto
    { Should be the helium dispenser sound }
    WwiseEvent Property SoundFuelTankUse Mandatory Const Auto
    { drsc_heliumopen }
    WwiseEvent Property SoundSiphon Mandatory Const Auto
    { Possibly also the fuel tank sound, do I have one on? }
    WwiseEvent Property SoundFAILURE Mandatory Const Auto
    { I can proc this via Fail() if something goes wrong }
    Message Property _rf_smartfuel_finishedhelium Mandatory Const Auto
    Message Property _rf_smartfuel_finishedtankmultiple Mandatory Const Auto
    WwiseEvent Property SoundStart Mandatory Const Auto
    WwiseEvent Property SoundSuccess Mandatory Const Auto
    Message Property _RF_Fueling_NG_WouldBeWaste Mandatory Const Auto
EndGroup

Actor PlayerRef
SpaceshipReference MyShip
SpaceshipReference SiphonedShip

int StartupTimer = 1

Location[] TwinStars ; Filled on startup from a formlist... I fucking hate property arrays

Location[] SysCore ; Yet again, I fucking hate arrays. Just yoink these on startup like the twins.
Location[] SysPeriphery
Location[] SysOuterRim 

float ShipFuelAvailable = 1.0 ; Actual AV amount. Updated in GetFuelLevel     
float ShipMaximumRange = 1.0 ; This is in light years. I probably don't need it
int LastPercent = 100 ; Updated in Restrictions()
bool JumpWasIntrasystem = false ; Updated in GetTravelDistance. True = No Grav Stuff
bool SpoolingUp = false ; Set in GravJumpHandler() in state 0
bool TwinJump = False ; Drain will be random under 20 if this is true
bool MyOldShipSteal = False ; In exactly one scenario a different message will show
bool FirstStart = false ; This will trigger the mod to start OnSit
int Zone = 0 ; Set in Distancecompare

int CurrentSystemType = 0

float FuelToDrawSender = 0.0 ; This would be called from the DLL sender script and fed in 
float SiphonableFuel = 1.0 ; This is updated OnDocking

bool AutoRefuelRunning = false ; Prevent spam on panel activate

;Counts for breakpoints
int BreakHigh = 70
int BreakNorm = 40
int BreakMerg = 25
int BreakCrit = 10

;System
bool RF = false ; Is the mod running
bool DEBUGON = true ; Debug handler
bool DEBUGNOTIFY = false ; I can't tell how fast the scripts are running with this spamming me lol
bool REALFUELON = false ; I don't want to use this until the scaling is set in stone. I also don't know how the fuck it works
bool DEBUGSTART = false ; The only debug implement is the free shit on startup


;----------------------------------------------------
;----------------- DEBUG AND SYSTEM ----------------- 
;----------------------------------------------------


;Generic debug function that can be disabled for prod
Function DBG(String asTextToPrint = "Debug Error!")
    If DEBUGON
        Debug.Trace("RF FuelHandler: " + asTextToPrint)
        IF DEBUGNOTIFY ; Can log in realtime to avoid alt-tabbing constantly
            Debug.Notification("RFUEL: " + asTextToPrint)
        EndIF
    EndIF
EndFunction

Function DBGVB(String asTextToPrint = "Debug Error!")
    If DEBUGON
        Debug.Notification("RFUEL: " + asTextToPrint)
    EndIF
EndFunction

;true indicates verbose
bool Function VB()
    bool verbose = false
    if _RF_Sys_Verbose.GetValue() == 1
        verbose = true
    endif
    return verbose
EndFunction

; Greater weight value increases chance of failing flip
bool Function CoinFlip(int aiWeight = 50)
    bool Heads = true
    int Coin = Utility.RandomInt(0, 100)
    If Coin <= aiWeight
        Heads = false
    EndIf
    Return Heads
EndFunction

; Gives us a 0.X > 1.X mult to use for randomization
float Function GetVariance(float afMax = 0.25)
    bool Random = Coinflip()
    float Divergence = 1.0
    float RandomAmount = Utility.RandomFloat(0.01, afMax)
    If Random
        Divergence = 1.0 - RandomAmount
    Else
        Divergence = 1.0 + RandomAmount
    EndIF
    return Divergence
EndFunction

Function HandleSettings()
    int Mode = _RF_Sys_ModEnabled.GetValue() as int
    int Travel = _RF_Sys_AllowTravel.GetValue() as int
    int Verbose = _RF_Sys_Verbose.GetValue() as int ; This gets checked each call - whatever
    If Mode != 1 ; Mod is disabled in settings
        If RF
            MyShip.RestoreValue(SpaceshipGravJumpFuel, 9999)
            Utility.Wait(4)
            Debug.Notification("Ship Fuel restored to " + GF(MyShip) as int)
            DBG("Mod shutting down")
        EndIf
        RF = False
        FirstStart = True
        PerkRefresh(false)
    Else
        If !RF
            DBG("Mod restarting")
            Dashboard()
        EndIf
        RF = True
        PerkRefresh(true)
    EndIF
EndFunction

;True if we are... False otherwise
bool Function ModRunning()
    Return RF
EndFunction

;This returns true if we have at least one
bool Function CheckHold(Form asFormToCheck)
    bool HasItem = false
    If MyShip && asFormToCheck
        int AmountInHold = MyShip.GetItemCount(asFormToCheck)
        If  AmountInHold > 0
            HasItem = True
        EndIf
        DBG("CheckHold ran for " + asFormToCheck + " returning " + AmountInHold )
    EndIf
    Return HasItem
EndFunction

; Returns an item to our inventory or hold. if mod is disabled it prompts an idiot alert
Function HandleReturn(Form asFormToReturn, bool abGoingToHold = false, bool abSilent = false)
    If !abSilent
        Fail()
    EndIf
    If !abGoingToHold
        PlayerRef.AddItem(asFormToReturn, 1, true)
    Else
        MyShip.AddItem(asFormToReturn, 1, true)
    EndIF
    If !RF
        ;Debug.Notification("This cannot be used right now.")
        _rf_item_failure.show()
    EndIF
EndFunction

; Does exactly what you think it does
Bool Function InMyShip()
    Bool ShipOK = false
    ShipOK = _RF_COND_PlayerShipInterior.IsTrue(PlayerRef) 
    DBG("InMyShip returned " + ShipOK + " with location " + PlayerRef.GetCurrentLocation() ) 
    Return ShipOK
EndFunction

;returns current fuel value of a ship sans strings
float Function GF(SpaceshipReference ShipToCheck)
    Return ShipToCheck.GetValue(SpaceshipGravJumpFuel)
EndFunction

;returns base fuel value of a ship sans strings
float Function GBF(SpaceshipReference ShipToCheck)
    Return ShipToCheck.GetBaseValue(SpaceshipGravJumpFuel)
EndFunction

;Quick refresh - probably not needed but whatever
Function PerkRefresh(bool abEnable)
    IF abEnable
        If !PlayerRef.HasPerk(_RF_Perk)
            PlayerRef.AddPerk(_RF_Perk)
        EndIf
    Else
        If PlayerRef.HasPerk(_RF_Perk)
            PlayerRef.RemovePerk(_RF_Perk)
        EndIf
    EndIF
EndFunction

;To check if we need to be able to take cargo panel actions
Function CheckAltActions()
    int activate = 0
    If LastPercent < BreakHigh
        activate = 1   
    ElseIf MyOldShipSteal || SiphonedShip
        activate = 1
    EndIf
    _RF_State_CanActivateCargoPanel.SetValue(activate)
EndFunction

bool Function IsSettled(Location akLocation)
    bool Settled = true
    Location[] Orbital = akLocation.GetParentLocations(LocTypeMajorOrbital)
    If Orbital[0].HasKeyword(LocTypeSettledPlanet)
       Settled = True
    Else
        Settled = False 
    EndIF
    DBG("IsSettled returned " + Settled + " for loc " + Orbital[0])
    Return Settled
EndFunction

Function Fail()
    SoundFAILURE.Play(PlayerREf)
EndFunction


;-------------------------------------------------
;----------------- SYSTEM CHECKS -----------------
;-------------------------------------------------


; Thanks Google!
bool Function is_valid_pair_difference(int x, int y)
    bool pair = false
    int diff = Math.Abs(x - y) as int
    int minVal = Math.Min(x, y) as int
    if diff == 1 && (minVal % 2) == 0
        pair = true
    endif
    ;DBG("pairdiff got " + pair + " from x " + X + " and y " + y)
    return pair
EndFunction

bool Function CheckForTwinStars(Location aOldSys, Location aNewSys)
    bool Pair = False
    int NewSysLoc = TwinStars.Find(aNewSys)
    int OldSysLoc = TwinStars.Find(aOldSys)
    If NewSysLoc + OldSysLoc >= 0 ; This is only true if *both* are twin stars
        Pair = is_valid_pair_difference(NewSysLoc, OldSysLoc)
    EndIF
    ;DBG("CFTS(TM) got " + Pair + " from new " + aNewSys + ": " + NewSysLoc + " and old " + aOldSys + ":" + OldSysLoc)
    Return Pair
EndFunction

;This returns what kind of system we are in
;0:Core 1:Periphery 2:Outer 3: Wastes
int Function GetSysType(Location akLocation)
    int Type = 3
    If StarSystemsCore.Find(akLocation) >= 0
        Type = 0
    ElseIf StarSystemsPeriphery.Find(akLocation) >= 0
        Type = 1
    ElseIf StarSystemsOuterRim.Find(akLocation) >= 0
        Type = 2
    EndIF
    Return Type
EndFunction

; This will create an additive float to push onto DistanceMultFlat 
; This in turn lets us use more or less fuel according to zone transition
; Ranges from 1.175 to 9
float Function CompareTypes(int aiO, int aiN)
    float Distance = 0
    float Divergence = 0
    int RealDist = Math.abs(aiN - aiO) as int
    Zone = RealDist * 2
    If aiO > aiN    ; towards core - lower down to 0.75x
        Divergence = RealDist * ( 0.75 * GetVariance() ) 
    Else            ; towards periphery - higher up to 1.25x
        Divergence = RealDist * ( 1.25 * GetVariance() ) 
    EndIF
    aiO += 1 ; Can't multiply by 0 if I want this to work
    aiN += 1
    int OXN = aiO * aiN ; This is at minimum 1 and at maximum 16 - enough variance for me imo
    Distance = ( OXN / 4 ) + 1 ; This is the fun part... This would range from 1.175 to 5
    float Output = Distance + Divergence ; This can be minimum 1.175 + 0 and at max 5 + 4
    DBG("CompareTypes got " + Output + " from Distance " + Distance + " + Disparity " + Divergence + " for Old: " + aiO + " New: " + aiN)
    return Output
EndFunction

;This can now range up to, theoretically, 15 but probably won't
float Function CheckLocationDistance(Location aDepartureLocation, Location aArrivalLocation)
    float LocationDistanceMult = 1
    Location[] NewLocArray = aArrivalLocation.GetParentLocations(LocTypeStarSystem)
    Location[] OldLocArray = aDepartureLocation.GetParentLocations(LocTypeStarSystem)
    Location MyNewLoc = NewLocArray[0]
    Location MyOldLoc = OldLocArray[0]
    If MyNewLoc != MyOldLoc
        TwinJump = CheckForTwinStars(MyOldLoc, MyNewLoc)
        If !TwinJump
            int TypeNew = GetSysType(MyNewLoc)
            int TypeOld = GetSysType(MyOldLoc)
            CurrentSystemType = TypeNew
            float Dist = CompareTypes(TypeOld, TypeNew) ; This can be up to 8x which means if I times distanceflat it becomes up to 80...
            ;LocationDistanceMult = TypeNew + TypeOld + Dist; I'll just add Dist for now - maxes therefore at ~7 (since N+O=6 means 0 divergence)
            LocationDistanceMult = Zone + Dist
        EndIF
    EndIf
    DBG("CheckLocationDistance got " + LocationDistanceMult )
    Return LocationDistanceMult
EndFunction

bool Function GetWasJumpIntrasystem(Location akOldLoc, Location akNewLoc)
    JumpWasIntrasystem = false
    JumpWasIntrasystem = akOldLoc.IsSameLocation(akNewLoc, LocTypeStarSystem) ; thanks jduvall. Great function
    DBG( "Intrasystem: " + JumpWasIntrasystem  )
    Return JumpWasIntrasystem
EndFunction

Function SmartNotify(int aiPercent = 120, bool abForce = false)
    If aiPercent > 100 ; indicates failure or default
        aiPercent = GetFuelLevelInt()
    EndIf
    If aiPercent >= BreakNorm
        _RF_Message_FuelRemainingOK.Show(aiPercent)
    Else
        If TravelManager.CheckTravelStatus() || abForce; skip the annoying AF nag warnings if travel is disabled.
            If aiPercent >= BreakMerg
                _RF_Message_FuelRemainingLOW.Show(aiPercent)
            Else
                _RF_Message_FuelRemainingNG.Show(aiPercent)
            EndIf
        EndIf
    EndIF
EndFunction


;--------------------------------------------------
;----------------- FUELING SYSTEM -----------------
;--------------------------------------------------


; This is our scripted internal handler to add fuel. 
; Add all of it or add some, that's it. No notifs
; The return value is the clamped amount we used.
int Function Realfuel(bool abComplete, float afAmount = 1.0, bool abSkipDashboard = false)
    int Withdrawn = 0
    Float FuelMissing = GBF(MyShip) - GF(MyShip)
    If abComplete
        MyShip.RestoreValue(SpaceshipGravJumpFuel, FuelMissing)
        DBG("RealFuel: COMPLETE " + FuelMissing + " RESULTING " + GF(MyShip) )
        Withdrawn = FuelMissing as int
    Else
        float AmountToFill = Math.Clamp(afAmount, 0, FuelMissing)
        MyShip.RestoreValue(SpaceshipGravJumpFuel, AmountToFill)
        Withdrawn = AmountToFill as int
        DBG("RealFuel: STANDARD " + AmountToFill + " FROM " + afAmount + " RETURNS " + Withdrawn)
    EndIf
    If !abSkipDashboard ; Only use this for Siphoning
        Dashboard()
    EndIf
    Return Withdrawn
EndFunction

; This is done silently, and notifications are all handled later
Function HandleDrawingFuel(float afDistance)

    ; A-B-C-M corresponds to 27 > 70 > 120 > 220
    ; Note: Should be 24 > 30 > 50 > 70
    Float FuelToDrain = 1.0
    float Variance = GetVariance(0.15)
    float ADSkill = CheckAstrodynamics()
    float InShip = GF(MyShip)
    float Cap = GBF(MyShip) * 0.8 * GetVariance(0.05)
    int ReactorClass = ShipModuleClasses.Find(MyShip.GetReactorClassKeyword())
    int BaseDraw = 27 ; (ShipModuleClassMults[ReactorClass] as GlobalVariable).GetValue() as int
    int ExtraDraw = _RF_Drain.GetValue() as int ; This is a smidge high for short jumps still...
    If Myship.GetValue(SpaceshipPartsMass) < 300
        BaseDraw = 7
    EndIf
    float DistanceDerived = ( afDistance ) * 0.75 ; I need to rethink the math another time
    float ShipMult = GetShipMassMult()

    float Dlimit = BaseDraw * 6 ; This will range from 27 + 100 to 70 + 280
    float DDraw = Math.Clamp(( ExtraDraw * ShipMult * DistanceDerived * Variance ), BaseDraw, Cap)
    float EDraw = Math.Clamp(DDraw, 0, Dlimit)
    
    FuelToDrain = ( BaseDraw + EDraw ) * ADSkill * GetVariance(0.05)
    
    DBG("Calcs got DDraw of " + DDraw + " from " + ShipMult + " x " + DistanceDerived + " x " + ExtraDraw + " x " + Variance)
    ;FuelToDrain = (BaseDraw + (ExtraDraw * ShipMult * DistanceDerived)) * Variance * ADSkill
    
    If TwinJump ; override
        FuelToDrain = BaseDraw * Utility.RandomFloat(0.25, 0.45)
        DBG("DrawingFuel Override: TWIN " + FuelToDrain )
    EndIF
     
    float FuelClamped = Math.Clamp( FuelToDrain , 0 , InShip )
    
    DBG("DrawingFuel:" + FuelClamped as int + " Clamped from " + FuelToDrain )
    MyShip.DamageValue(SpaceshipGravJumpFuel, FuelClamped)

    Dashboard()

EndFunction

; Handler function to remove fuel. 
; Does not include Dashboard() as this is typically used for Siphoning or external calls.
Function ForceDrainFuel(bool abComplete, Float afAmount = 0.0)
    MyShip = SQ_PlayerShip.PlayerShip.GetShipRef()
    float FuelInTank = CheckFuelAmount()
    float FuelToDrain = 1.0
    If abComplete
        FuelToDrain = FuelInTank
    Else
        if afAmount > 0
            FuelToDrain = Math.Clamp(afAmount, 0, FuelInTank)
        EndIf
    EndIf
    MyShip.DamageValue(SpaceshipGravJumpFuel, ( FuelToDrain - 1 ) )
    DBG("ForceDrained " + FuelToDrain + "from " + FuelInTank) ; No dashboard! Only call on disaster or before RealFuel
EndFunction

bool Function RefuelFromHoldManual()
    Utility.Wait(1.7)
    _rf_smartfuel_init.show()
    float FuelWeNeed = CheckFuelAmount(true)
    int HeliumInHold = MyShip.GetItemCount(InorgCommonHelium3)
    DBG("RFHM thinks we need " + FuelWeNeed + " with available he3 " + HeliumInHold)
    float Efficiency = 0.85 * GetVariance(0.1)
    float HeliumToConsume = Math.Clamp(HeliumInHold, 0, FuelWeNeed)
    float HeliumWeGet = HeliumToConsume * Efficiency
    DBG("RFHM got HeliumWeGet " + HeliumWeGet + " with FuelWeNeed " + FuelWeNeed + " and efficiency" + Efficiency + " using he3 " + HeliumToConsume )
    If HeliumWeGet > 15 ; This is just a nitpick but if it keeps causing problems I will cut it
        Realfuel(false, HeliumWeGet)
        MyShip.RemoveItem(InorgCommonHelium3, HeliumToConsume as int, true)
        Utility.Wait(4)
        ;SoundForRawFuelRefill.Play(PlayerRef)
        StartFuelSound() ; I will have to do so much testing for these fucking sounds man
        _rf_smartfuel_foundhelium.Show(HeliumToConsume)
        float WaitTime = ( HeliumToConsume * 0.07 ) + 4 ; This would be a little too fast for small amounts so + 4
        Utility.Wait(WaitTime)
        _rf_smartfuel_finishedhelium.show(LastPercent)
        StartFuelSound(false)
        return true
    Else
        DBG("RefuelFromHoldManual failed. Going to RefuelFromHold")
        return false
    EndIF
EndFunction

;Called from our smart activate on the panel
bool Function RefuelFromHold()
    int i = 0
    int Count = 0
    int Type = 0
    bool Found = false
    bool Success = false
    Form Tank
    While i < FuelTanks.Length
        IF !Found
            If CheckHold(FuelTanks[i]) ; This will still only trigger our smallest tank.
                Tank = FuelTanks[i] as Form
                Count = MyShip.GetItemCount(Tank)
                Type = i
                Found =  True
            EndIf
        EndIF
        i += 1
    EndWhile
    If Tank
        Utility.Wait(4)
        If GetFuelLevelInt() > BreakNorm ; If it is actually low we check if we can spam. Cool!
            MyShip.RemoveItem(Tank, 1, true)
            PlayerRef.AddItem(Tank, 1, true)
            _rf_smartfuel_foundtank.Show()
            Utility.Wait(3)
            PlayerRef.EquipItem(Tank, false, true) ; ENDCHAIN - no further notifs except in TankHandler.
            Success = True
            DBG("RefuelFromHold successful using " + Tank)
        Else
            ; We want to use as many of these as we need to get to 80%
            float Req =  ( GBF(MyShip) * 0.8 ) - GF(MyShip) ; This should do it
            float Fill = 1.0
            If Type == 0
                Fill = 25
            ElseIF Type == 1
                Fill = 50
            Else
                Fill = 125
            EndIf
            int CanUse = Math.Floor( Req / Fill ) ; Should do the trick
            If Fill / 3 > Req
                _RF_Fueling_NG_WouldBeWaste.Show()
                DBG("RefuelFromHold skipped via overflow logic")
            Else
                int ToUse = Math.Clamp(CanUse, 1, Count) as int ; why the fuck was this 0
                MyShip.RemoveItem(Tank, ToUse) ; Now we just need to add the fuel
                ;SoundFuelTankUse.Play(PlayerRef)
                _rf_smartfuel_foundtank.Show()
                Utility.Wait(2.5)
                StartFuelSound()
                _RF_Fueling_Message_starting.Show(CheckFuelAmount() as int)
                float WaitTime = ( ToUse * 5 ) + 4 ; This will be 1:1 for 1 and then progressively faster - perfect
                Utility.Wait(WaitTime)
                Realfuel(false, ToUse * Fill, true)
                _rf_smartfuel_finishedtankmultiple.Show(ToUse, CheckFuelAmount() as int) ; ENDCHAIN - no further notifs except in TankHandler.
                StartFuelSound(false)
                Success = True
                DBG("RefuelFromHold successful using " + ToUse + " " + Tank + " for fill " + ToUse * Fill)
            EndIf
        EndIF
    Else
        DBG("RefuelFromHold failed")
    EndIf
    Return Success
EndFunction

Function StartFuelSound(bool abStop = false)
    If abStop
        ;PlayerRef.DispelSpell(_RF_FX_He3soundeffect)
        SoundSuccess.Play(PlayerRef)
    Else
        ;_RF_FX_He3soundeffect.Cast(PlayerREf) 
        SoundFuelTankUse.Play(PlayerRef)
    EndIf
EndFunction

Function SmartFuel()
    If !AutoRefuelRunning
        DBG("SmartFuel beginning")
        _RF_State_IsRefuelingOK.SetValue(1)
        SoundWhenTriggeringSmartFuel.Play(PlayerRef)
        AutoRefuelRunning = True
        If GetFuelLevelInt() < BreakHigh || MyOldShipSteal
            If SiphonedShip
                SiphonFuel(false)
            Else
                bool HadRawFuel = RefuelFromHoldManual()
                If !HadRawFuel
                    bool HadFuelCanister = RefuelFromHold()
                    If !HadFuelCanister
                        Utility.Wait(3)
                        ;Debug.Notification("No available refuel methods found.")
                        _rf_smartfuel_failure.show()
                        Fail()
                    EndIf
                EndIf
            EndIf
        EndIf
        Dashboard()
        AutoRefuelRunning = False
        DBG("SmartFuel ending")
    Else
        _rf_smartfuel_busy.Show()
    EndIF
EndFunction


;-------------------------------------------------
;----------------- SHIP CHECKERS -----------------
;-------------------------------------------------


; Quick handler to print our current fuel level
float Function GetFuelLevel()
    float FuelAvailable = 1.0
    float FuelNow = GF(MyShip)
    If FuelNow > 0
        FuelAvailable = FuelNow / GBF(MyShip)
    Else
        MyShip.RestoreValue(SpaceshipGravJumpFuel, Math.abs(FuelNow))
        FuelAvailable = 0
    EndIf
    ShipFuelAvailable = FuelNow
    DBG( "PlayerShip Float: " + FuelAvailable + ". Stored: " + ShipFuelAvailable as int)
    return FuelAvailable
EndFunction

int Function GetFuelLevelInt()
    float FuelAvailable = 1.0
    float FuelNow = GF(MyShip)
    float FuelAll = GBF(MyShip)
    If FuelNow > 0
        FuelAvailable = ( FuelNow / ( FuelAll ) * 100 ) as int
    Else
        MyShip.RestoreValue(SpaceshipGravJumpFuel, Math.abs(FuelNow))
        FuelAvailable = 0
    EndIf
    LastPercent = FuelAvailable as int
    DBG( "PlayerShip Percent: " + FuelAvailable as int + "% " + FuelNow as int + "/" + FuelAll as int)
    Return FuelAvailable as int
EndFunction

; Returns float value of the fuel in our tanks.
; If called true, returns float value of empty space in tanks
float Function CheckFuelAmount(bool abAmountMissing = false)
    float Fuel = 1
    If !abAmountMissing
        Fuel =  MyShip.GetValue(SpaceshipGravJumpFuel)
        DBG("Current Fuel: " + Fuel)
    Else
        Fuel = MyShip.GetBaseValue(SpaceshipGravJumpFuel) - MyShip.GetValue(SpaceshipGravJumpFuel)
        DBG("Missing Fuel: " + Fuel)
    EndIF
    Return Fuel
EndFunction

; This should be called before *anything* as there is no real automatic update
SpaceshipReference Function GetShip(String asCallingScript = "FuelManager")
    MyShip = SQ_PlayerShip.PlayerShip.GetShipRef()
    DBG( "Found: " + MyShip + " from " + asCallingScript )
    Return MyShip
EndFunction

;New math based around the ExtraDraw method
float Function GetShipMassMult()
    float MassScale = 1.0
    float Mass = MyShip.GetValue(SpaceshipPartsMass)
    MassScale = Math.Clamp(( Mass / 350), 0.25, 3)
    ;DBG("GetShipMassMult got " + MassScale + " from ship size " + Mass)
    Return MassScale
EndFunction

;This returns a float value to match the vanilla skill % reduction
Float Function CheckAstrodynamics()
    float AmountToLower = 1.0
    int RankFound = 0
    int i = 0
    While i < AstrodynamicsRank.length
        If AstrodynamicsRank[i].IsTrue(PlayerRef)
            AmountToLower = AstrodynamicsMults[i].GetValue()
            RankFound = i
        EndIf
        i += 1
    EndWhile
    ;DBG("CheckAstrodynamics returning " + AmountToLower + " from rank:" + RankFound)
    Return AmountToLower
EndFunction

Function SiphonClear()
    SiphonableFuel = 0
    SiphonedShip = None
    MyOldShipSteal = False
EndFunction

Function TriggerBounty(Faction akFaction)
    float SiphonPenalty = _RF_Val_SiphoningCrimeGoldValue.GetValue()
    If akFaction
        akFaction.ModCrimeGold(SiphonPenalty as int, false)
        DBG("Triggered bounty of " + SiphonPenalty + " with " + akFaction)
    Else
        Faction Reporting = CheckShipCrime()
        If Reporting
            Reporting.ModCrimeGold(SiphonPenalty as int, false)
            DBG("Triggered bounty of " + SiphonPenalty + " with " + Reporting)
        Else
            DBG("TriggerBounty did not find faction")
        EndIF
    EndIf
EndFunction

; AIO handler function to check and clean out all of our systems and values
Function Dashboard()
    GetShip()
    GetFuelLevel()
    GetFuelLevelInt()
    SiphonClear()
    CheckAltActions()
    travelManager.CheckRestrictions(LastPercent)
    TravelManager.SmartLimitHandler(CurrentSystemType)
    DisasterManager.HandleDisasterSystem()
    DialogueShipServices.UpdateFuelGlobals()
    TwinJump = False
    JumpWasIntrasystem = False
    FuelToDrawSender = 0
    _RF_State_IsRefuelingOK.SetValue(0)
EndFunction


;-------------------------------------------------
;----------------- SYSTEM/EVENTS -----------------
;-------------------------------------------------


Function ImportTwinStars()
    Int listSize = _RF_TwinStarFormlist.GetSize()
    TwinStars = new Location[listSize]
    Int i = 0
    While i < listSize
        TwinStars[i] = _RF_TwinStarFormlist.GetAt(i) as Location
        i += 1
    EndWhile
EndFunction

;This should get our current fuel level and set up our ship
Function HandleModStartup()
    RF = True
    ;This is just Dashboard() in a slightly different order
    GetShip()
    GetFuelLevel()
    GetFuelLevelInt()
    CheckAltActions()
    TravelManager.TravelSystemEnabled() ; This is just to kickstart - the only time this needs to change after is from SettingsScript
    travelManager.CheckRestrictions()
    DisasterManager.HandleDisasterSystem()
    ;TravelManager.SmartLimitHandler(CurrentSystemType) - No system yet which is fine.
    DialogueShipServices.UpdateFuelGlobals()
    TwinJump = False
    JumpWasIntrasystem = False
    FuelToDrawSender = 0
    _RF_State_IsRefuelingOK.SetValue(0)
    PerkRefresh(true)
    Debug.Notification("Real Fuel running. " + CheckFuelAmount() as int + " Fuel available.")
EndFunction

Event OnQuestInit()
    StartTimer(3, StartupTimer)
EndEvent

Event OnTimer(int aiTimerID)

    PlayerRef = Game.GetPlayer()
    RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
    RegisterForRemoteEvent(PlayerRef, "OnExitShipInterior")
    RegisterForRemoteEvent(PlayerRef, "OnHomeShipSet")
    RegisterForRemoteEvent(PlayerRef, "OnPlayerModifiedShip")
    RegisterForRemoteEvent(PlayerRef, "OnPlayerBuyShip")
    RegisterForRemoteEvent(PlayerREf, "OnSit")
    RegisterForMenuOpenCloseEvent("GalaxyStarMapMenu")
    ImportTwinStars()
    FirstStart = True

    If DEBUGSTART
        PlayerRef.AddItem(DebugPotion1, 3, true)
        ;PlayerRef.AddItem(DebugPotion2, 3, true)
        ;PlayerRef.AddItem(DebugPotion3, 3, true)
        ;PlayerRef.AddItem(DebugPotion4, 3, true)
        ;Debug.Notification("Fueling items added for testing.")
        ;Utility.Wait(3)
        ;_rf_purchase_complementary.Show(GF(MyShip) as int)
    EndIf
    ;HandleModStartup()
EndEvent

;Mostly just for notifications at this point, I don't need it for logic
Event OnMenuOpenCloseEvent(String asMenuName, Bool abOpening)
    If asMenuName == "GalaxyStarMapMenu" && RF
        If abOpening
            If TravelManager.GetOverheated()
                Debug.Notification("Grav Drive overheated! Repair to continue.")
            Else
                If LastPercent <= BreakCrit
                    TutorialManager.Nag(1)
                Else
                    SmartNotify()
                EndIf
            EndIF
        Elseif !abOpening
            ;Do nothing
        EndIF
    EndIf
EndEvent

;Transfers our old fuel amount to the new ship exactly (overflow is lost)
Event Actor.OnPlayerModifiedShip(Actor akSender, SpaceshipReference akShip)
    DBG("PlayerModifiedShip on firing has current fuel " + CheckFuelAmount() + " vs last stored " + ShipFuelAvailable )
    If RF
        float NewFuel = CheckFuelAmount()
        GetShip()
        ForceDrainFuel(true)
        Realfuel(false, ShipFuelAvailable)
        SmartNotify() ; I love this function
        DBG("PlayerModifiedShip after mod has current fuel " + CheckFuelAmount() + " vs last stored " + ShipFuelAvailable )
    EndIf
EndEvent

;This is technically different enough from the above that I don't want to merge code
Function HandleShipPurchase(SpaceshipReference akShip)
    If RF
        DBG("HandleShipPurchase fired with current fuel " + CheckFuelAmount() + " vs last stored " + ShipFuelAvailable )
        Utility.Wait(4) ; God only knows how long the vanilla jank takes to fire
        float Gratis = ( GF(akShip) * 0.45 * GetVariance() ) + ShipFuelAvailable ; May as well give you some of the old fuel as well
        ForceDrainFuel(true)
        Realfuel(false, Gratis)
        ;Debug.Notification("Purchased ship came with " + FuelInNew + " complementary He-3.")
        _rf_purchase_complementary.show(GF(MyShip) as int)
        DBG("HandleShipPurchase after mod has current fuel " + CheckFuelAmount() + " vs recently stored " + ShipFuelAvailable )
    EndIf
EndFunction

;Fires the above
Event Actor.OnPlayerBuyShip(Actor akSender, SpaceshipReference akShip)
    HandleShipPurchase(akShip)
EndEvent

Event Actor.OnHomeShipSet(Actor akSender, SpaceshipReference akShip, SpaceshipReference akPrevious)
    IF RF
        DBG("Ship changed with previous " + akPrevious + " and current " + akShip)
        Location PlayerIsIn = PlayerRef.GetCurrentLocation()
        If PlayerIsIn.HasKeyword(LocTypeOutpost) || PlayerIsIn.HasKeyword(LocTypeSettlement)
            If akPrevious == akShip
                Utility.Wait(5)
                SmartNotify()
            EndIF
        EndIf
    EndIf
EndEvent

;Sanity checks everything
Event Actor.OnPlayerLoadGame(Actor akSender)
    ModRunning()
    If RF
        GetShip()
        FirstStart = False ; Safety for updates - may or may not work idk
    EndIf
EndEvent

;This handles just about everything and should be fast and robust (hence arrays only in CheckDistance etc)
Function HandleLocChange(Location akOldLoc, Location akNewLoc, bool IsTravelRestricted)
    If RF
        If !JumpWasIntrasystem ; This gets set earlier by our ShipTracker.
            bool GravDriveFailure = IsTravelRestricted
            If !GravDriveFailure
                float TravelDistance = CheckLocationDistance(akOldLoc, akNewLoc)
                HandleDrawingFuel(TravelDistance) ; Still no notifs so I can call one here
                Utility.Wait(3)
                SmartNotify(LastPercent)
            Else
                DBG("Detected GravDriveFailure - draining remaining fuel.")
                ForceDrainFuel(true)
                Dashboard() ; I shouldn't use forcedrain but I don't want to add a whole function
            EndIf
        Else

            Dashboard()
        EndIf
    EndIf
EndFunction

; Event received when a ship initiates and completes docking with a parent
; This will be used for refueling
Function HandleDocking(bool abComplete, SpaceshipReference akDocking, SpaceshipReference akParent)
    If RF
        GetShip()
        If myShip == akDocking
            SiphonedShip = akParent
            Faction SiphonCrimeFaction = akParent.GetCrimeFaction()
            DBG("Ship crime faction is " + SiphonCrimeFaction)
            float myfuel = GF(akDocking)
            float theirfuel = GF(akParent)
            float fuel2rand = Math.Clamp( ( ( theirfuel * 0.45 ) * GetVariance(0.4) ), 25, 1000 )
            DBG("Detected dock with akDocking: " + akDocking + " having " + myfuel + "and akParent " + akParent + " having " + theirfuel + " randomized to " + fuel2rand )
            SiphonableFuel = fuel2rand
        EndIF
    EndIf
EndFunction

; Sanity check to clear even if no locchange occured
Function HandleUndocking(bool abComplete, SpaceshipReference akDocking, SpaceshipReference akParent)
    DBG("Running Siphon info clear on HandleUndocking")
    Dashboard()
    DBG( "SiphonShip should be None:" + SiphonedShip + "with amount 0: " + SiphonableFuel )
EndFunction

; Event received when a ship begins or ends far travel - State { Departure = 0, Arrival = 1 }
Function HandleFarTravel(Location aDepartureLocation, Location aArrivalLocation, int aState)
    ; I can't seem to figure out what to use this for...
EndFunction

; Event received when a ship grav jump event occurs - State { Initiated = 0, AnimStarted = 1, Completed = 2, Failed = 3 }
Function HandleGravJump(Location aDestination, int aState)
    ;DBG("HandleGravJump: fired with State " + aState)
    ;If aState
    ;    If aState == ( 0 || 1 ) ; This will trigger our state to avoid clearing map set value!
    ;        DBG("HandleGravJump: spoolup detected")
    ;        SpoolingUp = True
    ;    Else
    ;        DBG("HandleGravJump: complete or failure detected")
    ;        SpoolingUp = False
    ;        ;FuelToDrawSender = 0 ; This would maybe not have cleared on a successful jump from OnOpenGalaxy etc.
    ;    EndIf
    ;EndIf
EndFunction

; Event that is triggered when fuel has been added to this spaceship
; Check if this triggers with our fuel consumable before hooking up the script. It didn't seem to.
Function HandleRefuel(int aFuelAdded)
    DBG("Refuel for " + aFuelAdded + "Detected")
    DialogueShipServices.UpdateFuelGlobals()
EndFunction

; Event received when a ship initiates or completes takeoff
Function HandleShipTakeOff(bool abComplete)
    Dashboard()
EndFunction

Event Actor.OnSit(Actor akSender, ObjectReference akFurniture)
    IF FirstStart
        If akSender == PlayerRef && akFurniture.HasRefType(Ship_PilotSeat_RefType)
            HandleModStartup()
            RF = True
            FirstStart = False
        EndIF
    Else
        If RF
            If akSender == PlayerRef && akFurniture.HasRefType(Ship_PilotSeat_RefType)
                Utility.Wait(3) ; Not sure how long takeover scripts take to run  
                DBG("OnSit detected - comparing ships")
                SpaceshipReference ThisShip = PlayerRef.GetCurrentShipRef()
                If ThisShip != MyShip
                    Takeover(ThisShip, MyShip)
                EndIf
            EndIf
        EndIf
    EndIF
EndEvent

; Reassigns our ship to the correct one and sets the old one as a siphon target
Function Takeover(SpaceshipReference TheNewShip, SpaceshipReference MyOldShip)
    float NewShipFuel = Math.Clamp( GF(TheNewShip), 15, GBF(TheNewShip) ) ; Avoid floating errors by adding a negligible amount
    float OldShipFuel = Math.Clamp( GF(MyOldShip), 15, GBF(MyOldShip) )
    DBG("Takeover running on New " + TheNewShip + " having " + NewShipFuel + " vs Old " + MyOldShip + " having" + OldShipFuel)
    Float RandomFillLevel = Utility.RandomFloat(0.35, 0.8)
    float NewShipRoll = Math.Clamp( ( ( NewShipFuel * RandomFillLevel ) * GetVariance(0.15) ), 0, 1000 )
    GetShip()
    If MyShip == TheNewShip
        SiphonedShip = MyOldShip
        SiphonableFuel = OldShipFuel
        MyOldShipSteal = True
        DBG("Takeover successful with " + MyShip + " == " + TheNewShip + ". Draining and setting Siphons as " + SiphonedShip + "with Fuel " + SiphonableFuel)
        ForceDrainFuel(true)
        Realfuel(false, NewShipRoll)
        Utility.Wait(0.75)
        ;Debug.Notification("This ship has " + NewShipRoll as int + " He-3.")
        _rf_takeover.Show(NewShipRoll as int, GBF(MyShip) as int)
    Else
        DBG("TAKEOVER FAIL - EXCEPTION")
    EndIF
EndFunction


;-----------------------------------------------------------
;----------------- EXTERNAL FUNCTION CALLS -----------------
;-----------------------------------------------------------



Faction Function CheckShipCrime()
    Faction Controls
    GetShip()
    Location ShipIsIn = MyShip.GetCurrentLocation()
    If UCStarstations.Find(ShipIsIn) > 0
        Controls = CrimeFactionUC
    EndIF
    DBG("Ship is in " + ShipISIn + " for faction check " + Controls)
    Return Controls
EndFunction

Function SiphonFuel(bool abWithDevice = true)
    If RF
        bool Success = false
        DBG("SiphonFuel called externally. Found stored value " + SiphonableFuel + " and ship " + SiphonedShip)
        If SiphonableFuel > 0 && SiphonedShip
            Utility.Wait(0.75)
            int GoAhead = 0
            If !abWithDevice
                If !MyOldShipSteal
                    ;Debug.Notification("Docked vessel detected. Siphoning is available.")
                    _rf_siphon_begin_generic.Show()
                    Utility.Wait(3)
                    GoAhead = _RF_SiphonFuelWarning.Show()
                Else
                    ;Debug.Notification("Siphoning from former vessel...")
                    _rf_siphon_begin_oldship.Show()
                    GoAhead = 1
                EndIF
            Else
                GoAhead = 1
                ;Debug.Notification("Docked vessel detected. Launching Siphon malware.")
                _rf_siphon_begin_item.Show()
            EndIf
            If GoAhead == 1
                DBG("SiphonFuel - Starting siphon procedure")
                Faction SiphonCrimeFaction = SiphonedShip.GetCrimeFaction()
                Utility.Wait(7)
                int Withdrawn = Realfuel(false, SiphonableFuel, true) ; This smart-clamps so we don't have to worry about overflow.
                _rf_siphon_success.show(Withdrawn as int)
                ;SOUNDMARK - SOMETHING TECHNICAL
                ;SoundSiphon.Play(PlayerRef)
                SoundStart.Play(PlayerREf)
                Success = True
                SiphonedShip.DamageValue( SpaceshipGravJumpFuel, ( Withdrawn - 5 ) )
                If !abWithDevice && !MyOldShipSteal
                    TriggerBounty(SiphonCrimeFaction) ; This should always return empty against my vessel but I will include a safety
                Else
                    If MyOldShipSteal
                        HandleReturn(_RF_FuelSiphon)
                        ;Debug.Notification("I didn't need this to draw from my old vessel.")
                        _rf_siphon_fail_oldship.Show()
                    EndIF
                EndIF
                Utility.Wait(3)
                Dashboard()
                SmartNotify(LastPercent)
            Else
                Utility.Wait(2)
                Dashboard()
                _rf_siphon_fail_cancel.Show()
                Fail()
            EndIf
        EndIf    
        If !Success
            If abWithDevice
                HandleReturn(_RF_FuelSiphon)
                ;Debug.Notification("Siphoning currently unavailable.")
                _rf_siphon_fail_generic.Show()
            EndIf
        EndIF
    Else
        If abWithDevice
            HandleReturn(_RF_FuelSiphon)
        EndIf
    EndIF
EndFunction

Function HandleActivateCargoPanel()
    SmartFuel()
EndFunction

Function HandleActivateFuelContainer(ObjectReference akTargetRef)
    IF RF
        int He3InContainer = akTargetRef.GetItemCount(InorgCommonHelium3)
        DBG("Container has " + He3InContainer + "Helium") ; We will use this at 100% efficiency
        If He3InContainer > (MyShip.GetBaseValue(SpaceshipGravJumpFuel) * 0.10)
            Debug.Notification("He-3 found. Beginning transfer.")
            int FuelGotten = Realfuel(false, He3InContainer)
            akTargetRef.RemoveItem(InorgCommonHelium3, FuelGotten)
            Utility.Wait(4)
            Debug.Notification("Refueling procedure complete.")
            Utility.Wait(2)
            SmartNotify(LastPercent)
            ;DialogueShipServices.UpdateFuelGlobals() ; RealFuel handles this - Thanks realfuel!
        Else
            Utility.Wait(2)
            Debug.Notification("Insufficient He-3 for Refueling.")
        EndIf
    EndIf
EndFunction